### Preventing Malware Attacks

- **Established Attacks**:
    - Easier to prevent with documented strategies.
    - Use of IPS signatures, updated IP/domain block lists, and antivirus signatures.
- **New Attacks**:
    - Difficult to detect and prevent.
    - Requires quick identification tools to mitigate risk and damage.
### Role of Threat Analytic Systems

- **Purpose**:
    - Correlate large data sets using statistical and mathematical models.
    - Discover novel and emerging threats by identifying C&C activity of malware.
- **Benefits**:
    - Reduce time to discover threats inside the network.
    - Address gaps in perimeter-based defenses through behavioral analysis and anomaly detection.
    - Achieve a very low false positive rate (0.000001%).

### ***Cisco Extended Detection and Response (XDR)***

- **Detection Capabilities**:
    - Uses network traffic behavior analysis, machine learning, and anomaly detection.
    - Effective where zero-day threat detection might fail.
    - Analyzes data over time to identify abnormal events.
- **Big Data Capabilities**:
    - Identifies smaller incidents from discreet attacks.
    - Prevents larger damage by compiling and analyzing data.

### Case Study: DNS Changer Trojan

- **Detection Efficiency**:
    - Cisco detected the attack faster than traditional signature-based methods.
- **Trojan Functionality**:
    - Changes DNS settings to redirect requests to attacker-controlled servers.
    - Executes commands using PowerShell for remote access.
    - Maintains persistence by creating a scheduled task.

### Data Analysis and Threat Alerts

- **Data Sources**:
    - Web traffic from Cisco Secure Web Appliance.
    - Endpoint data from Cisco Secure Endpoint.
    - Network data from Cisco Secure Network Analytics.
- **Machine Learning**:
    - Identifies malicious activity through network telemetry data.

### Impact on Security Analysts

- **Assistance**:
    - Provides 100% confirmed breaches.
    - Keeps analysts focused on devices needing remediation.

